/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.patron_pet;

import com.alexander.mutantmore.patron_pet.screen.PatronPetScreen;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PatronPetUtils {
    public static List<String> verifiedPatrons = Lists.newArrayList();
    public static List<String> verifiedNonPatrons = Lists.newArrayList();

    public static boolean isPlayerAPatron(Player player) {
        if (player != null) {
            if (PatronPetUtils.isPlayerVerified(player)) {
                return verifiedPatrons.contains(player.m_7755_().getString());
            }
            if (PatronPetUtils.isStringPatron(player.m_7755_().getString())) {
                verifiedPatrons.add(player.m_7755_().getString());
                return true;
            }
            verifiedNonPatrons.add(player.m_7755_().getString());
        }
        return false;
    }

    public static boolean isPlayerVerified(Player player) {
        return verifiedPatrons.contains(player.m_7755_().getString()) || verifiedNonPatrons.contains(player.m_7755_().getString());
    }

    public static boolean isStringPatron(String Patron) {
        StringBuilder response = new StringBuilder();
        try {
            String inputLine;
            URL website = new URL("https://skald.uk/craft/idpatron.php?patron=" + Patron);
            URLConnection connection = website.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Boolean.parseBoolean(response.toString());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void displayPatronPetGUI(boolean shouldSpawnParticles, boolean active, boolean playAudio) {
        Minecraft.m_91087_().m_91152_((Screen)new PatronPetScreen(shouldSpawnParticles, active, playAudio));
    }
}

